# mappings between architectures  

The main function of interest, which maps a CNN to its eFCN, may be found in mappings.py under cnn2fc.

The jupyter notebook analysis.ipynb allows to regenerate all figures in the paper and Supplemental Material, thanks to the data saved in the "results" and "analysis" folders. Some of the calculations, marked with "NEED THE WEIGHTS", require the snapshots of the weights to be performed, but these are not included due to their memory size.

To regenerate the figures of the paper from scratch:

1. python run_cnn.py  
2. python run_efcn.py  
3. python run_fcn.py  
4. Run the whole jupyter notebook  

To generate the same figures but for cifar100 with alexnet like in the Supplemental Material:  

1. python run_cnn.py --dataset cifar100 --model alexnetprime  
2. python run_efcn.py --dataset cifar100 --model alexnetprime  
3. python run_fcn.py --dataset cifar100 --model alexnetprime  
4. Run the whole jupyter notebook but setting dataset='cifar100' and model='alexnet' at the beginning   